<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('archivos_carpetas', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('subfolder_id');
            $table->text('ruta');
            $table->string('archivo',250);

            $table->foreign('subfolder_id')->references('id')->on('subcarpetas');

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('archivos_carpetas');
    }
};
