<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        Schema::create('carpetas', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('subject_id');
            $table->string('nombre',50);
            $table->string('descripcion',450)->nullable();
            $table->tinyInteger('estado')->nullable();

            $table->foreign('subject_id')->references('id')->on('asignaturas');

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('carpetas');
    }
};
