<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        Schema::create('practicas_efsrt', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('agreement_id')->nullable();
            $table->unsignedBigInteger('subjectenrollment_id');

            $table->double('total_horas')->nullable();
            $table->double('calificacion')->nullable();
            $table->text('informacion')->nullable();
            $table->text('documento')->nullable();

            $table->foreign('agreement_id')->references('id')->on('convenios_efsrt');
            $table->foreign('subjectenrollment_id')->references('id')->on('matriculas_asignaturas');

            $table->timestamps();
        });
    }
    
    public function down(): void
    {
        Schema::dropIfExists('practicas_efsrt');
    }
};
