<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    
    public function up(): void
    {
        Schema::create('convenios_efsrt', function (Blueprint $table) {
            $table->id();
            
            $table->unsignedBigInteger('company_id')->nullable();

            $table->date('fecha_inicio')->nullable();
            $table->date('fecha_fin')->nullable();
            $table->text('documento')->nullable();
            $table->text('descripcion')->nullable();

            $table->foreign('company_id')->references('id')->on('bt_empresas');

            $table->timestamps();
        });
    }
    
    public function down(): void
    {
        Schema::dropIfExists('convenios_efsrt');
    }
};
