<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('respuestas_usuarios', function (Blueprint $table) {
            $table->id();
            $table->foreignId('pregunta_id')->constrained('preguntas')->onDelete('cascade');
            $table->foreignId('respuesta_id')->nullable()->constrained('opciones_respuesta')->onDelete('cascade');
            $table->foreignId('user_id')->nullable()->constrained('usuarios')->onDelete('cascade');
            $table->text('respuesta_texto')->nullable(); // Campo para preguntas de tipo texto
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('respuestas_usuarios');
    }
};
