<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sub_modulos', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('module_id');
            $table->string('nombre'); // Nombre del submenú
            $table->string('route'); // Ruta del submenú
            $table->integer('pocision_sm');
            $table->timestamps(); // Created_at y Updated_at

            $table->foreign('module_id')->references('id')->on('modulos');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sub_modulos');
    }
};
