<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('td_movimientos', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('area_origen_id');
            $table->unsignedBigInteger('area_destino_id');
            $table->unsignedBigInteger('td_id');
            $table->dateTime('fecha');
            $table->string('nota', 255);

            $table->foreign('area_origen_id')->references('id')->on('areas')->onDelete('restrict');
            $table->foreign('area_destino_id')->references('id')->on('areas')->onDelete('restrict');
            $table->foreign('td_id')->references('id')->on('tds')->onDelete('restrict');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('td_movimientos');
    }
};
