<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tds', function (Blueprint $table) {
            $table->id();

            $table->string('serie', 45);
            $table->string('numero', 45);

            $table->text('info_asunto');
            $table->text('info_documentos')->nullable();
            $table->integer('info_folios');
            $table->dateTime('fecha');

            $table->tinyInteger('is_eliminado');

            $table->text('pdf_recibido');
            $table->text('pdf_respuesta')->nullable();
            $table->text('nota_respuesta')->nullable();

            $table->unsignedBigInteger('area_id');
            $table->unsignedBigInteger('td_tipo_id');
            $table->unsignedBigInteger('td_estado_id');
            $table->unsignedBigInteger('user_id')->nullable();

            //
            $table->string('nombres', 45)->nullable();
            $table->string('apellido_pa', 45)->nullable();
            $table->string('apellido_ma', 45)->nullable();
            $table->text('direccion')->nullable();
            $table->string('celular', 45)->nullable();
            $table->string('telefono', 45)->nullable();
            $table->string('correo', 45)->nullable();
            $table->string('numero_documento', 45)->nullable();

            $table->unsignedBigInteger('tipo_solicitante_id')->nullable();
            $table->unsignedBigInteger('tipo_identificacion_id')->nullable();
            $table->unsignedBigInteger('programa_id')->nullable();
            $table->string('ubigeo_id', 6)->nullable();

            $table->foreign('tipo_solicitante_id')->references('id')->on('td_tipos_solicitantes');
            $table->foreign('tipo_identificacion_id')->references('id')->on('tipos_identificaciones');
            $table->foreign('ubigeo_id')->references('id')->on('ubigeos');
            $table->foreign('programa_id')->references('id')->on('programas');
            //


            $table->foreign('area_id')->references('id')->on('areas')->onDelete('restrict');
            $table->foreign('td_tipo_id')->references('id')->on('td_tipos')->onDelete('restrict');
            $table->foreign('td_estado_id')->references('id')->on('td_estados')->onDelete('restrict');
            $table->foreign('user_id')->references('id')->on('usuarios')->onDelete('restrict');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tds');
    }
};
