<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    
    public function up(): void
    {
        Schema::create('viaticos', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('usuario_id')->nullable();
            $table->unsignedBigInteger('administrator_id')->nullable();
            $table->unsignedBigInteger('metodo_pago_id')->nullable();
            $table->unsignedBigInteger('banco_id')->nullable();

            $table->text('descripcion')->nullable();
            $table->double('monto')->nullable();
            $table->date('fecha')->nullable();
            $table->string('nro_operacion', 256)->nullable();
            $table->text('documento')->nullable();
            $table->tinyInteger('estado')->nullable();

            $table->foreign('usuario_id')->references('id')->on('usuarios');
            $table->foreign('administrator_id')->references('id')->on('administradores');
            $table->foreign('metodo_pago_id')->references('id')->on('metodos_pagos');
            $table->foreign('banco_id')->references('id')->on('bancos');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('viaticos');
    }
};
