<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    
    public function up(): void
    {
        Schema::create('pagos', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('student_id')->nullable();
            $table->unsignedBigInteger('administrator_id')->nullable();
            $table->unsignedBigInteger('concepto_id')->nullable();
            $table->unsignedBigInteger('metodo_pago_id')->nullable();
            $table->unsignedBigInteger('banco_id')->nullable();
            $table->unsignedBigInteger('semester_id')->nullable();


            // $table->string('codigo', 256)->unique();
            $table->date('fecha')->nullable();
            $table->text('documento')->nullable();
            $table->string('nro_operacion', 256)->nullable();
            $table->double('monto_inicial')->nullable();
            $table->double('descuento')->nullable();
            $table->double('monto_final')->nullable();
            $table->tinyInteger('estado')->nullable();
            $table->text('resolucion')->nullable();
            $table->text('descripcion')->nullable();


            $table->foreign('student_id')->references('id')->on('estudiantes');
            $table->foreign('administrator_id')->references('id')->on('administradores');
            $table->foreign('concepto_id')->references('id')->on('conceptos');
            $table->foreign('metodo_pago_id')->references('id')->on('metodos_pagos');
            $table->foreign('banco_id')->references('id')->on('bancos');
            $table->foreign('semester_id')->references('id')->on('semestres');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pagos');
    }
};
