<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('traslados_externos', function (Blueprint $table) {
            $table->id();

            $table->string('institucion_origen', 256);
            $table->string('programa_origen', 256);
            
            $table->unsignedBigInteger('plan_id2');


            $table->unsignedBigInteger('transfer_id');

            
            $table->foreign('plan_id2')->references('id')->on('planes');
            $table->foreign('transfer_id')->references('id')->on('traslados');


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('traslados_externos');
    }
};
