<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('convalidaciones_estudiantes', function (Blueprint $table) {
            $table->id();


            $table->unsignedBigInteger('courseequivalence_id');
            $table->unsignedBigInteger('student_id');


            $table->date('fecha');
            $table->text('documento');


            $table->foreign('courseequivalence_id')->references('id')->on('equivalencias_cursos');
            $table->foreign('student_id')->references('id')->on('estudiantes');


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('convalidaciones_estudiantes');
    }
};
