<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('equivalencias_cursos', function (Blueprint $table) {
            $table->id();


            $table->unsignedBigInteger('course_id1');
            $table->unsignedBigInteger('course_id2');
            $table->text('documento');
            $table->unsignedBigInteger('planequivalence_id');


            $table->foreign('course_id1')->references('id')->on('cursos');
            $table->foreign('course_id2')->references('id')->on('cursos');
            $table->foreign('planequivalence_id')->references('id')->on('equivalencias_planes');


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('equivalencias_cursos');
    }
};
