<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bt_trabajos', function (Blueprint $table) {
            $table->id();

            $table->string('puesto', 45);
            $table->integer('vacantes');
            $table->string('tipo', 45);
            $table->string('modalidad', 45);
            $table->string('experiencia', 45);
            $table->date('fecpublicacion');
            $table->date('feccierre');
            $table->float('salariomin');
            $table->float('salariomax');
            $table->string('nivel_educativo', 45);
            $table->text('link')->nullable();
            $table->text('descripcion')->nullable();
            $table->tinyInteger('estado');

            $table->unsignedBigInteger('jpcompany_id');
            $table->unsignedBigInteger('jpcategory_id');
            $table->string('ubigeo_id', 6);

            $table->foreign('jpcompany_id')->references('id')->on('bt_empresas');
            $table->foreign('jpcategory_id')->references('id')->on('bt_categorias');
            $table->foreign('ubigeo_id')->references('id')->on('ubigeos');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bt_trabajos');
    }
};
