<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('fichas_socioeconomicas', function (Blueprint $table) {
            $table->id();


            $table->string('estado_civil', 45);
            $table->unsignedBigInteger('nro_hijos');
            $table->float('ingreso_mensual');
            $table->string('ocupacion', 45);
            $table->string('empresa', 45);
            $table->string('tipovivienda', 45);
            $table->float('gastos_mensuales');

            $table->string('flg_trabaja', 2);
            $table->string('tipo_empresa', 250);
            $table->string('rubro_empresa', 250);

            $table->string('nombre_jefe', 250);
            $table->string('forma_contrato', 250);
            $table->string('flg_antes_trabajaba', 250);

            $table->string('meses_no_trabaja', 250);
            $table->string('explicacion', 250);
            $table->string('form_prof_recibida', 250);

            $table->string('carrera_satis_necesi', 250);
            $table->string('area_carrera_profesiona_beneficiado', 250);
            $table->string('satisfecho_form_institu_brindo', 250);
            
            $table->string('motivos_satisfecho_form_institu_brindo', 250);
            $table->string('razon_form_institu_brindo', 250);


            $table->unsignedBigInteger('student_id');


            $table->foreign('student_id')->references('id')->on('estudiantes');

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('fichas_socioeconomicas');
    }
};
