<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        Schema::create('documentos_estudiantes', function (Blueprint $table) {
            $table->id();

            $table->string('nombre', 45);
            $table->date('fecha_solicitud');
            $table->date('fecha_inicio');
            $table->text('ruta'); // jefferson
            $table->text('descripcion');
            $table->tinyInteger('estado');

            $table->unsignedBigInteger('student_id');


            $table->foreign('student_id')->references('id')->on('estudiantes');


            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('documentos_estudiantes');
    }
};
