<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('notas_estudiantes', function (Blueprint $table) {
            $table->id();


            $table->unsignedBigInteger('subjectenrollment_id');
            $table->unsignedBigInteger('grade_id')->nullable();


            $table->tinyInteger('asistencia');
            $table->float('nota')->nullable();


            $table->foreign('subjectenrollment_id')->references('id')->on('matriculas_asignaturas')->onDelete('restrict');
            $table->foreign('grade_id')->references('id')->on('notas')->onDelete('restrict');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('notas_estudiantes');
    }
};
