<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('notas', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('activity_id')->nullable();
            $table->unsignedBigInteger('subjectclass_id')->nullable();

            $table->string('nombre', 45)->nullable();
            $table->float('porcentaje')->nullable();

            $table->foreign('activity_id')->references('id')->on('actividades')->onDelete('restrict');
            $table->foreign('subjectclass_id')->references('id')->on('clases_asignaturas')->onDelete('restrict');

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('notas');
    }
};
