<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('indicadores', function (Blueprint $table) {
            $table->id();


            $table->unsignedBigInteger('subject_id');


            $table->string('nombre', 45)->nullable();
            $table->string('descripcion', 45)->nullable();
            $table->date('fecha')->nullable();


            $table->foreign('subject_id')->references('id')->on('asignaturas');


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('indicadores');
    }
};
