<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('asistencias', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('subjectclass_id');
            $table->unsignedBigInteger('subjectenrollment_id');

            $table->tinyInteger('estado');

            $table->foreign('subjectclass_id')->references('id')->on('clases_asignaturas')->onDelete('restrict');
            $table->foreign('subjectenrollment_id')->references('id')->on('matriculas_asignaturas')->onDelete('restrict');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('asistencias');
    }
};
