<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('clases_asignaturas', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('schedule_id');

            $table->string('nombre', 45);
            $table->string('dia', 45);
            $table->date('fecha');
            $table->tinyInteger('estado');

            $table->foreign('schedule_id')->references('id')->on('horarios')->onDelete('restrict');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('clases_asignaturas');
    }
};
