<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('postulantes', function (Blueprint $table) {
            $table->id();

            // $table->string('tipoidenti', 45);
            $table->unsignedBigInteger('identificationtype_id')->nullable();
            $table->string('nroidenti', 45);
            $table->string('nombres', 45);
            $table->string('apellido_pa', 45);
            $table->string('apellido_ma', 45);
            $table->date('fecnac');
            $table->string('correo', 45);
            $table->string('tlf', 45);
            $table->string('celular', 45);
            $table->string('lugarnac', 45);
            $table->string('direccion', 45);

            $table->text('docdni');
            $table->text('doccertif');
            $table->text('docboucher');
            $table->text('docdatosper');

            $table->float('nota')->nullable();
            $table->tinyInteger('estado');
            $table->string('comentario', 256);
            $table->string('modalidad', 45);
            $table->string('tipomod', 45);
            $table->string('estado_admision', 45);
            // $table->dateTime('fec_preinscripcion');
            // $table->dateTime('fec_preinscripcion_validacion');
            // $table->dateTime('fec_inscripcion');
            // $table->dateTime('fec_inscripcion_validacion');
            $table->string('ubigeo_id', 6)->nullable();
            $table->unsignedBigInteger('genre_id')->nullable();
            $table->unsignedBigInteger('admissionplan_id');


            $table->foreign('identificationtype_id')->references('id')->on('tipos_identificaciones');
            $table->foreign('ubigeo_id')->references('id')->on('ubigeos');
            $table->foreign('genre_id')->references('id')->on('generos');
            $table->foreign('admissionplan_id')->references('id')->on('admisiones_planes');


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('postulantes');
    }
};
