<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('admisiones_planes', function (Blueprint $table) {
            $table->id();

            $table->unsignedBigInteger('admission_id');
            $table->unsignedBigInteger('plan_id');

            $table->integer('vacantes_ordinario')->nullable();
            $table->integer('vacantes_exoneracion')->nullable();
            $table->integer('puntaje_minimo')->nullable();


            $table->foreign('plan_id')->references('id')->on('planes');
            $table->foreign('admission_id')->references('id')->on('admisiones');


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('admisiones_planes');
    }
};
