<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('horarios', function (Blueprint $table) {
            $table->id();


            $table->string('dia', 45);
            $table->time('horaini');
            $table->time('horafin');
            $table->time('duracion')->nullable();


            $table->unsignedBigInteger('subject_id');
            $table->unsignedBigInteger('classroom_id')->nullable();


            $table->foreign('subject_id')->references('id')->on('asignaturas');
            $table->foreign('classroom_id')->references('id')->on('aulas');


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('horarios');
    }
};
