<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('matriculas_semestres', function (Blueprint $table) {
            $table->id();


            $table->unsignedBigInteger('semester_id');
            $table->unsignedBigInteger('student_id');


            $table->date('fecha');
            $table->text('docboucher'); // jefferson
            $table->tinyInteger('estado')->nullable();


            $table->foreign('semester_id')->references('id')->on('semestres');
            $table->foreign('student_id')->references('id')->on('estudiantes');


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('matriculas_semestres');
    }
};
