<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('asignaturas', function (Blueprint $table) {
            $table->id();

            $table->string('seccion', 45)->nullable();
            $table->string('turno', 45)->nullable();
            $table->string('tipo', 45)->nullable();
            $table->float('cupos')->nullable();
            $table->float('nota_minima')->nullable();
            $table->text('silabo')->nullable();
            $table->text('instrumentos_evaluacion')->nullable();

            $table->unsignedBigInteger('course_id');
            $table->unsignedBigInteger('semester_id');
            $table->unsignedBigInteger('teacher_id')->nullable();

            $table->integer('subject_moodle_category_id');

            $table->foreign('course_id')->references('id')->on('cursos')->onDelete('restrict');
            $table->foreign('semester_id')->references('id')->on('semestres')->onDelete('restrict');
            $table->foreign('teacher_id')->references('id')->on('docentes')->onDelete('restrict');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('asignaturas');
    }
};
