<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('periodos_semestres', function (Blueprint $table) {
            $table->id();


            $table->unsignedBigInteger('semester_id');
            $table->unsignedBigInteger('period_id');

            $table->integer('moodle_parent_category_id');
            $table->integer('moodle_category_id');

            $table->foreign('semester_id')->references('id')->on('semestres');
            $table->foreign('period_id')->references('id')->on('periodos');


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('periodos_semestres');
    }
};
