<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cursos', function (Blueprint $table) {
            $table->id();


            $table->string('tipo', 45)->nullable();
            $table->string('codcurso', 45)->nullable();
            $table->string('nombre', 256)->nullable();
            $table->string('codpredecesor', 45)->nullable();
            $table->integer('horas')->nullable();
            $table->integer('creditos')->nullable();


            $table->unsignedBigInteger('period_id')->nullable();
            $table->unsignedBigInteger('training_module_id')->nullable();


            $table->foreign('period_id')->references('id')->on('periodos')->onDelete('cascade');
            $table->foreign('training_module_id')->references('id')->on('modulos_formativos')->onDelete('cascade');


            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cursos');
    }
};
