<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('modulos_formativos', function (Blueprint $table) {
            $table->id();

            $table->integer('numero')->nullable();
            $table->string('codigo', 255)->nullable();
            $table->text('descripcion')->nullable();
            $table->unsignedBigInteger('plan_id');

            $table->foreign('plan_id')->references('id')->on('planes')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('modulos_formativos');
    }
};
