<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('planes', function (Blueprint $table) {
            
            $table->id();
            
            $table->string('nombre',45);
            $table->string('tipo',45)->nullable();
            $table->string('modalidad',45)->nullable();
            $table->string('enfoque',45)->nullable();
            $table->date('fecha')->nullable();
            $table->text('documento')->nullable();
            
            $table->unsignedBigInteger('program_id');
            
            $table->foreign('program_id')->references('id')->on('programas')->onDelete('cascade');
            
            $table->timestamps();
        });
    }
    
    public function down(): void
    {
        Schema::dropIfExists('planes');
    }
};
