<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('docentes', function (Blueprint $table) {

            $table->id();


            // $table->string('tipocontrato',45);
            $table->integer('horas_lectivas');
            $table->integer('horas_nolectivas');
            $table->tinyInteger('estado');


            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('teachercontracttype_id');
            $table->unsignedBigInteger('teachertype_id');

            $table->string('account_id')->nullable()->after('teachertype_id');
            $table->string('client_id')->nullable()->after('account_id');
            $table->string('client_secret')->nullable()->after('client_id');

            $table->foreign('user_id')->references('id')->on('usuarios')->onDelete('cascade');
            $table->foreign('teachercontracttype_id')->references('id')->on('tipos_contratos_docentes');
            $table->foreign('teachertype_id')->references('id')->on('tipos_docentes');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('docentes');
    }
};
