<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('usuarios', function (Blueprint $table) {
            $table->id();


            // $table->string('tipoidenti',45);
            $table->unsignedBigInteger('identificationtype_id')->nullable();
            $table->string('nroidenti',45)->unique();
            $table->string('password',256);
            $table->string('google_id')->nullable()->unique();
            $table->string('avatar')->nullable();
            $table->string('nombres',45)->nullable();
            $table->string('apellido_pa',45)->nullable();
            $table->string('apellido_ma',45)->nullable();
            $table->date('fecnac')->nullable();
            $table->string('correo',45)->nullable();
            $table->string('telefono',45)->nullable();
            $table->string('celular',45)->nullable();
            $table->text('direccion')->nullable();
            $table->tinyInteger('estado')->nullable();


            $table->string('ubigeo_id',6)->nullable();
            $table->unsignedBigInteger('genre_id')->nullable();
            $table->unsignedBigInteger('usertype_id')->nullable();


            $table->foreign('ubigeo_id')->references('id')->on('ubigeos');
            $table->foreign('genre_id')->references('id')->on('generos');
            $table->foreign('usertype_id')->references('id')->on('tipos_usuarios');
            $table->foreign('identificationtype_id')->references('id')->on('tipos_identificaciones');


            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('usuarios');
    }
};
