<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Module>
 */
class SubmoduleFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $lista = $submenus = [
            ['module_id' => 1, 'nombre' => 'Roles', 'route' => 'admin.seguridad.roles', 'pocision_sm' => 1],
            ['module_id' => 1, 'nombre' => 'Permisos a Modulos', 'route' => 'admin.seguridad.permisos', 'pocision_sm' => 2],
            ['module_id' => 1, 'nombre' => 'Usuarios', 'route' => 'admin.seguridad.administradores', 'pocision_sm' => 3],

            ['module_id' => 2, 'nombre' => 'Gestionar Programas', 'route' => 'admin.institucion.programas', 'pocision_sm' => 1],
            ['module_id' => 2, 'nombre' => 'Gestionar Aulas', 'route' => 'admin.institucion.aulas', 'pocision_sm' => 2],
            ['module_id' => 2, 'nombre' => 'Gestionar Periodos Lectivos', 'route' => 'admin.institucion.semestres', 'pocision_sm' => 3],
            ['module_id' => 2, 'nombre' => 'Gestionar Convenios', 'route' => 'admin.institucion.convenios', 'pocision_sm' => 4],
            // ['module_id' => 2, 'nombre' => 'Gestionar Tipos de Identificación', 'route' => 'admin.institucion.tiposidenti', 'pocision_sm' => 3],

            ['module_id' => 3, 'nombre' => 'Importar Planes', 'route' => 'admin.planes_estudio.planes', 'pocision_sm' => 1],
            ['module_id' => 3, 'nombre' => 'Equivalencias', 'route' => 'admin.planes_estudio.equivalencias', 'pocision_sm' => 2],
            ['module_id' => 3, 'nombre' => 'Evaluacion Curricular', 'route' => 'admin.planes_estudio.evaluacion', 'pocision_sm' => 3],

            ['module_id' => 4, 'nombre' => 'Registrar cursos', 'route' => 'admin.cursos.periodos_semestre', 'pocision_sm' => 1],
            ['module_id' => 4, 'nombre' => 'Gestionar cursos', 'route' => 'admin.cursos.asignaturas', 'pocision_sm' => 2],
            ['module_id' => 4, 'nombre' => 'Prácticas EFSRT', 'route' => 'admin.cursos.efsrt', 'pocision_sm' => 3],

            ['module_id' => 5, 'nombre' => 'Gestionar Docentes', 'route' => 'admin.docentes.gestionar', 'pocision_sm' => 1],
            ['module_id' => 5, 'nombre' => 'Gestionar Tipos de Docente', 'route' => 'admin.institucion.tiposdocente', 'pocision_sm' => 2],
            ['module_id' => 5, 'nombre' => 'Gestionar Tipos de Contrato Docente', 'route' => 'admin.institucion.tiposcontratodocente', 'pocision_sm' => 3],
            
            ['module_id' => 6, 'nombre' => 'Gestionar Admisiones', 'route' => 'admin.admision.admisiones', 'pocision_sm' => 1],
            ['module_id' => 6, 'nombre' => 'Inscripción de Postulantes', 'route' => 'admin.admision.postulantes', 'pocision_sm' => 2],

            ['module_id' => 7, 'nombre' => 'Gestionar Estudiantes', 'route' => 'admin.incripcion.students', 'pocision_sm' => 1],
            ['module_id' => 7, 'nombre' => 'Convalidaciones', 'route' => 'admin.estudiantes.convalidaciones', 'pocision_sm' => 2],

            ['module_id' => 8, 'nombre' => 'Estudiantes en Periodos Lectivos', 'route' => 'admin.matricula.alumnos_semestre', 'pocision_sm' => 1],
            ['module_id' => 8, 'nombre' => 'Estudiantes en U.D.', 'route' => 'admin.matricula.alumnos_cursos', 'pocision_sm' => 2],
            ['module_id' => 8, 'nombre' => 'Reservas y Licencias de Estudiantes', 'route' => 'admin.matricula.reservas_licencias', 'pocision_sm' => 3],

            ['module_id' => 9, 'nombre' => 'Gestionar Tipos de Notas', 'route' => 'admin.notas.tipos_notas', 'pocision_sm' => 1],
            ['module_id' => 9, 'nombre' => 'Gestionar Indicadores, Actividades y Notas', 'route' => 'admin.notas.indicadores', 'pocision_sm' => 2],
            ['module_id' => 9, 'nombre' => 'Acta por Asignaturas', 'route' => 'admin.notas.notas_asignaturas', 'pocision_sm' => 3],
            ['module_id' => 9, 'nombre' => 'Acta por Estudiantes', 'route' => 'admin.notas.notas_alumnos', 'pocision_sm' => 4],

            ['module_id' => 10, 'nombre' => 'Asignar Horario', 'route' => 'admin.horarios.asignar_horario', 'pocision_sm' => 1],
            ['module_id' => 10, 'nombre' => 'Reporte Semestral', 'route' => 'admin.horarios.horario_general', 'pocision_sm' => 2],
            ['module_id' => 10, 'nombre' => 'Reporte Docentes', 'route' => 'admin.horarios.horario_docente', 'pocision_sm' => 3],
            ['module_id' => 10, 'nombre' => 'Reporte Estudiantes', 'route' => 'admin.horarios.horario_estudiante', 'pocision_sm' => 4],

            ['module_id' => 11, 'nombre' => 'Gestionar Anuncios', 'route' => 'admin.institucion.bienestar.publicaciones', 'pocision_sm' => 1],
            ['module_id' => 11, 'nombre' => 'Gestionar Encuestas', 'route' => 'admin.institucion.bienestar.encuestas', 'pocision_sm' => 2],
            ['module_id' => 11, 'nombre' => 'Situación Estudiantes y Egresados', 'route' => 'admin.bolsa_laboral.situacion_estudiante', 'pocision_sm' => 3],

            ['module_id' => 12, 'nombre' => 'Gestionar Conceptos', 'route' => 'admin.registros_pagos.conceptos', 'pocision_sm' => 1],
            ['module_id' => 12, 'nombre' => 'Gestionar Métodos de Pago', 'route' => 'admin.registros_pagos.metodos_pagos', 'pocision_sm' => 2],
            ['module_id' => 12, 'nombre' => 'Gestionar Bancos', 'route' => 'admin.registros_pagos.bancos', 'pocision_sm' => 3],
            ['module_id' => 12, 'nombre' => 'Gestionar Pagos', 'route' => 'admin.registros_pagos.pagos', 'pocision_sm' => 4],
            ['module_id' => 12, 'nombre' => 'Gestionar Viáticos', 'route' => 'admin.registros_pagos.viaticos', 'pocision_sm' => 5],
            ['module_id' => 12, 'nombre' => 'Reportes', 'route' => 'admin.registros_pagos.reportes', 'pocision_sm' => 6],

            ['module_id' => 13, 'nombre' => 'Gestionar Áreas', 'route' => 'admin.institucion.areas', 'pocision_sm' => 1],
            ['module_id' => 13, 'nombre' => 'Áreas y Roles', 'route' => 'admin.institucion.roles_areas', 'pocision_sm' => 2],
            ['module_id' => 13, 'nombre' => 'Tipos de Trámite Documentario', 'route' => 'admin.institucion.td_tipos', 'pocision_sm' => 3],
            ['module_id' => 13, 'nombre' => 'Gestionar', 'route' => 'tramite_documentario.gestionar', 'pocision_sm' => 4],
            ['module_id' => 13, 'nombre' => 'Mis Trámites', 'route' => 'tramite_documentario.mis_tramites', 'pocision_sm' => 5],
            ['module_id' => 13, 'nombre' => 'Registrar', 'route' => 'tramite_documentario.registrar', 'pocision_sm' => 6],

            ['module_id' => 14, 'nombre' => 'Registro de Empresas', 'route' => 'admin.bolsa_laboral.empresas', 'pocision_sm' => 1],
            ['module_id' => 14, 'nombre' => 'Categorías', 'route' => 'admin.bolsa_laboral.categorias_etiquetas', 'pocision_sm' => 2],
            ['module_id' => 14, 'nombre' => 'Ofertas Laborales', 'route' => 'admin.bolsa_laboral.ofertas_laborales', 'pocision_sm' => 3,],
            ['module_id' => 14, 'nombre' => 'Postulaciones', 'route' => 'admin.bolsa_laboral.postulaciones', 'pocision_sm' => 4],
        ];


        $valor = $this->faker->unique()->randomElement($lista);

        return $valor;
    }
}
