<?php
// app/Services/SignedUrlService.php

namespace App\Services;

use Illuminate\Support\Facades\URL;
use Illuminate\Support\Str;

class SignedUrlService
{
    /**
     * Genera una URL firmada para acceder al examen.
     *
     * @param  int  $encuestaId
     * @return string
     */
    public function generateEncuestaLink($encuestaId)
    {
        $códigoAleatorio = Str::random(10);
        $url = URL::signedRoute('alumno.encuestas.solve',[$códigoAleatorio.':'.$encuestaId]);
        // Genera la URL firmada para acceder al examen con un tiempo de expiración
        return $url;


    }
}
