<?php
// app/Services/RucService.php
namespace App\Services;

use App\Models\Administrator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
class SidebarService
{

    public function ListmodulosSidebar()
    {
        $userId = Auth::User()->id;

        $result = Administrator::join('usuarios as u', 'administradores.user_id', '=', 'u.id')
        ->join('roles as r', 'administradores.role_id', '=', 'r.id')
        ->join('permisos as p', 'administradores.role_id', '=', 'p.role_id')
        ->join('modulos as m', 'p.module_id', '=', 'm.id')
        ->join('sub_modulos as sm', 'm.id', '=', 'sm.module_id')
        ->select(
            'u.nroidenti',
            'u.nombres as nombreusuario',
            'r.id as idrol',
            'r.nombre as nombrerol',
            'p.module_id as idpermiso',
            'm.nombre as nombremodulo',
            'm.icon as icon_simbolo',
            'm.pocision as orden',
            'sm.module_id',
            'sm.nombre as nombre_submodulo',
            'sm.route as nombre_ruta',
            DB::raw("CASE WHEN p.estado = 1 THEN 'Activo' ELSE 'Inactivo' END as estadomodulo")
        )
        ->where('u.id', '=', $userId)  // Usuario con ID 1
        ->where('p.estado', '=', 1)  // Solo permisos activos
        ->orderBy('m.pocision')
        ->orderBy('sm.pocision_sm')
        ->get();

        $menu = [];
        foreach ($result as $row) {
            // Verificamos si el módulo ya está agregado al menú
            if (!isset($menu[$row->nombremodulo])) {
                // Si no está, lo agregamos
                $menu[$row->nombremodulo] = [
                    'icon' => $row->icon_simbolo,
                    'name' => $row->nombremodulo,
                    'submenu' => []
                ];
            }

            // Agregamos el submenú
            $menu[$row->nombremodulo]['submenu'][] = [
                'name' => $row->nombre_submodulo,
                'route' => $row->nombre_ruta
            ];
        }

        return $menu;
    }

}
