<?php
// app/Services/RucService.php
namespace App\Services;

use App\Models\Administrator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class NotificacionesService
{

    public function ListNotificacionesEncuesta()
    {
        $userId =  Auth::User()->id; // Reemplaza con el ID del usuario

        $result = DB::table('encuestas as p')
            ->join('planes as pl', 'p.plan_id', '=', 'pl.id')
            ->join('estudiantes as es', 'pl.id', '=', 'es.plan_id')
            ->leftJoin('respuestas_usuarios as ru', function ($join) use ($userId) {
                $join->on('ru.pregunta_id', '=', DB::raw('(SELECT p2.id FROM preguntas as p2 WHERE p2.encuesta_id = p.id LIMIT 1)'))
                    ->where('es.user_id', '=', $userId);
            })
            ->select(
                'p.id',
                'p.titulo',
                'p.descripcion',
                'p.plan_id',
                'p.estado',
                'p.fecha_inicio',
                'p.fecha_fin',
                'es.user_id',
                'pl.nombre',
                'pl.tipo',
                'pl.modalidad',
                'pl.enfoque',
                'p.created_at as fecharegistro'
            )
            ->where('p.estado', '=', 'activa')
            ->where('es.user_id', '=', $userId)
            ->whereNull('ru.id') // Asegura que el usuario no haya respondido
            ->get();

        return $result;

    }

    public function ListNotificacionesPublicaciones()
    {

        $userId = Auth::User()->id;

        $result  = DB::table('publicacions as p')
            ->join('programas as pro', 'p.program_id', '=', 'pro.id')
            ->join('planes as pl', 'pro.id', '=', 'pl.program_id')
            ->join('estudiantes as es', 'pl.id', '=', 'es.plan_id')
            ->select(
                'p.id',
                'p.titulo',
                'p.program_id',
                'es.user_id',
                'pl.nombre',
                'pl.tipo',
                'pl.modalidad',
                'pl.enfoque',
                'p.created_at as fecharegistro'
            )
            ->where('es.user_id', '=', $userId)
            ->get();

        return $result;
    }
}
