<?php

namespace App\Services\Moodle;

use Illuminate\Support\Facades\Http;

class MoodleUserService extends MoodleService
{
    public function create($username, $password, $firstname, $lastname, $email)
    {
        $userData = [
            [
                'username' => $username,
                'password' => $password,
                'firstname' => $firstname,
                'lastname' => $lastname,
                'email' => $email,
                'auth' => 'manual',
            ]
        ];

        $params = [
            'wstoken' => $this->moodleToken,
            'wsfunction' => 'core_user_create_users',
            'moodlewsrestformat' => 'json',
            'users' => $userData,
        ];

        $response = Http::asForm()->post($this->moodleUrl, $params);
        return $response->json();
    }

    public function getAll()
    {
        $params = [
            'wstoken' => $this->moodleToken,
            'wsfunction' => 'core_user_get_users',
            'moodlewsrestformat' => 'json',
            'criteria' => []
        ];

        $response = Http::asForm()->post($this->moodleUrl, $params);
        return $response->json();
    }

    public function getOneById($userId)
    {
        $params = [
            'wstoken' => $this->moodleToken,
            'wsfunction' => 'core_user_get_users_by_field',
            'moodlewsrestformat' => 'json',
            'field' => 'id',
            'values' => [$userId]
        ];

        $response = Http::asForm()->post($this->moodleUrl, $params);
        return $response->json();
    }

    public function update($userId, $updatedData)
    {
        $userData = [
            array_merge(['id' => $userId], $updatedData)
        ];

        $params = [
            'wstoken' => $this->moodleToken,
            'wsfunction' => 'core_user_update_users',
            'moodlewsrestformat' => 'json',
            'users' => $userData,
        ];

        $response = Http::asForm()->post($this->moodleUrl, $params);
        return $response->json();
    }

    public function delete($userId)
    {
        $params = [
            'wstoken' => $this->moodleToken,
            'wsfunction' => 'core_user_delete_users',
            'moodlewsrestformat' => 'json',
            'userids' => [$userId]
        ];

        $response = Http::asForm()->post($this->moodleUrl, $params);
        return $response->json();
    }
}
