<?php

namespace App\Services\Moodle;

use Illuminate\Support\Facades\Http;

class MoodleRoleService extends MoodleService
{
    // -> revisar rol
    private function assignRoleToUser($roleId, $userId, $contextId = 1)
    {
        $roleAssignment = [
            [
                'roleid' => $roleId,
                'userid' => $userId,
                'contextid' => $contextId, // required
                // 'contextlevel' => $contextLevel, // invalid parameter
                // 'instanceid' => $instanceId, // invalid parameter
            ]
        ];

        $params = [
            'wstoken' => $this->moodleToken,
            'wsfunction' => 'core_role_assign_roles',
            'moodlewsrestformat' => 'json',
            'assignments' => $roleAssignment,
        ];

        $response = Http::asForm()->post($this->moodleUrl, $params);
        return $response->json();
    }

    public function assignAdminRoleToUser($userId)
    {
        return $this->assignRoleToUser(9, $userId);
    }

    private function unassignRoleToUser($roleId, $userId, $contextId = 1)
    {
        $roleUnassignment = [
            [
                'roleid' => $roleId,
                'userid' => $userId,
                'contextid' => $contextId, // required
                // 'contextlevel' => $contextLevel, // invalid parameter
                // 'instanceid' => $instanceId, // invalid parameter
            ]
        ];

        $params = [
            'wstoken' => $this->moodleToken,
            'wsfunction' => 'core_role_unassign_roles',
            'moodlewsrestformat' => 'json',
            'unassignments' => $roleUnassignment,
        ];

        $response = Http::asForm()->post($this->moodleUrl, $params);
        return $response->json();
    }

    public function unassignAdminRoleFromUser($userId)
    {
        return $this->unassignRoleToUser(9, $userId);
    }
}
