<?php

namespace App\Services\Moodle;

use Illuminate\Support\Facades\Http;

class MoodleEnrollmentService extends MoodleService
{

    private function enrollUserToCourse($userId, $courseId, $roleId = 5)
    {
        $enrolmentData = [
            [
                'roleid' => $roleId, // 5: estudiante, 3: docente (default)
                'userid' => $userId,
                'courseid' => $courseId,
            ]
        ];

        $params = [
            'wstoken' => $this->moodleToken,
            'wsfunction' => 'enrol_manual_enrol_users',
            'moodlewsrestformat' => 'json',
            'enrolments' => $enrolmentData,
        ];

        $response = Http::asForm()->post($this->moodleUrl, $params);
        return $response->json();
    }

    public function enrollStudentToCourse($userId, $courseId)
    {
        return $this->enrollUserToCourse($userId, $courseId, 5);
    }

    // -> revisar rol u opción vía BD
    public function enrollTeacherToCourse($userId, $courseId)
    {
        return $this->enrollUserToCourse($userId, $courseId, 11);
    }


    private function unenrollUserFromCourse($userId, $courseId, $roleId)
    {
        $unenrolmentData = [
            [
                'roleid' => $roleId,
                'userid' => $userId,
                'courseid' => $courseId,
            ]
        ];

        $params = [
            'wstoken' => $this->moodleToken,
            'wsfunction' => 'enrol_manual_unenrol_users',
            'moodlewsrestformat' => 'json',
            'enrolments' => $unenrolmentData,
        ];

        $response = Http::asForm()->post($this->moodleUrl, $params);
        return $response->json();
    }

    public function unenrollStudentFromCourse($userId, $courseId)
    {
        return $this->unenrollUserFromCourse($userId, $courseId, 5);
    }

    // -> revisar rol u opción vía BD
    public function unenrollTeacherFromCourse($userId, $courseId)
    {
        return $this->unenrollUserFromCourse($userId, $courseId, 11);
    }

}
