<?php

namespace App\Services\Moodle;

use Illuminate\Support\Facades\Http;

class MoodleCourseService extends MoodleService
{

    public function create($courseName, $courseShortName, $parentCategoryId, $summary = '')
    {
        $courseData = [
            [
                'fullname' => $courseName,     // Nombre completo del curso
                'shortname' => $courseShortName,    // Nombre corto del curso
                'categoryid' => $parentCategoryId,  // ID de la categoría donde se creará
                'summary' => $summary,        // Resumen opcional
                'summaryformat' => 1,          // Formato HTML
                'format' => 'topics',          // Formato del curso (puedes cambiarlo a 'weeks' si lo deseas)
                'visible' => 1                 // El curso será visible
            ]
        ];

        $params = [
            'wstoken' => $this->moodleToken,
            'wsfunction' => 'core_course_create_courses',
            'moodlewsrestformat' => 'json',
            'courses' => $courseData,
        ];

        $response = Http::asForm()->post($this->moodleUrl, $params);
        return $response->json();
    }

    public function getAll()
    {
        $params = [
            'wstoken' => $this->moodleToken,
            'wsfunction' => 'core_course_get_courses',
            'moodlewsrestformat' => 'json',
        ];

        $response = Http::asForm()->post($this->moodleUrl, $params);
        return $response->json();
    }

    public function getOneById($courseId)
    {
        $params = [
            'wstoken' => $this->moodleToken,
            'wsfunction' => 'core_course_get_courses_by_field',
            'moodlewsrestformat' => 'json',
            'field' => 'id',
            'value' => $courseId,
        ];

        $response = Http::asForm()->post($this->moodleUrl, $params);
        return $response->json();
    }

    public function delete($courseId)
    {
        $courseIds = [$courseId];

        $courses = array_map(fn($id) => ['id' => $id], (array) $courseIds);

        $params = [
            'wstoken' => $this->moodleToken,
            'wsfunction' => 'core_course_delete_courses',
            'moodlewsrestformat' => 'json',
            'courseids' => array_column($courses, 'id'),
        ];

        $response = Http::asForm()->post($this->moodleUrl, $params);
        return $response->json();
    }
}
