<?php

namespace App\Services\Moodle;

use Illuminate\Support\Facades\Http;

class MoodleCategoryService extends MoodleService
{

    public function create($categoryName, $parentCategoryId = 0)
    {
        $categoryData = [
            [
                'name' => $categoryName, // Nombre de la categoría
                'parent' => $parentCategoryId, // ID de la categoría padre, 0 para raíz
                'descriptionformat' => 1, // 1 para formato HTML
            ]
        ];

        // Parametros request
        $params = [
            'wstoken' => $this->moodleToken,
            'wsfunction' => 'core_course_create_categories',
            'moodlewsrestformat' => 'json',
            'categories' => $categoryData,
        ];

        // Enviar request
        $response = Http::asForm()->post($this->moodleUrl, $params);
        return $response->json();

        // // Obtener error por excepcion
        // if (isset($result['exception'])) {
        //     return response()->json([
        //         "status" => false,
        //         "mensaje" => 'Error: registros no guardado en Moodle'
        //     ]);
        // }
    }

    public function getAll($criteria = [])
    {
        $params = [
            'wstoken' => $this->moodleToken,
            'wsfunction' => 'core_course_get_categories',
            'moodlewsrestformat' => 'json',
            'criteria' => $criteria,
        ];

        $response = Http::asForm()->post($this->moodleUrl, $params);
        return $response->json();
    }

    public function delete($categoryId)
    {
        $categoryIds = [$categoryId];

        $categories = array_map(function ($id) {
            return ['id' => $id, 'recursive' => 1];
        }, (array) $categoryIds);

        $params = [
            'wstoken' => $this->moodleToken,
            'wsfunction' => 'core_course_delete_categories',
            'moodlewsrestformat' => 'json',
            'categories' => $categories,
        ];

        $response = Http::asForm()->post($this->moodleUrl, $params);
        return $response->json();
    }
}
