<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Services\SidebarService;
use Illuminate\Support\Facades\Session;

class SidebarServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {

        $this->app->singleton(SidebarService::class, function ($app) {
            return new SidebarService();
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot(SidebarService $sidebarService): void
    {

        view()->composer(['include.sidebar'], function ($view) use ($sidebarService) {
            $view->with([
                'datalistService' => $sidebarService->ListmodulosSidebar(),
                'loggedUserType' => Session::get('loggedUserType'),
            ]);
        });
    }
}
