<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Services\NotificacionesService;
use App\Services\SignedUrlService;


class NotificacionesProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        // Registrar el servicio NotificacionesService como singleton
        $this->app->singleton(NotificacionesService::class, function ($app) {
            return new NotificacionesService();
        });
        
        // Registrar el servicio SurveyUrlService como singleton
        $this->app->singleton(SignedUrlService::class, function ($app) {
            return new SignedUrlService();
        });
    }


    /**
     * Bootstrap services.
     */
    public function boot(NotificacionesService $notificacionesService, SignedUrlService $signedUrlService): void
    {
        // Compartir las notificaciones globalmente con vistas específicas
        view()->composer(['include.header'], function ($view) use ($notificacionesService, $signedUrlService) {
            // Obtener las notificaciones y publicaciones
            $notificacionesEncuesta = $notificacionesService->ListNotificacionesEncuesta();
            
            // Generar las URLs firmadas para cada encuesta
            $notificacionesEncuestasConUrls = $notificacionesEncuesta->map(function ($notificacion) use ($signedUrlService) {
                // Generar la URL firmada para cada encuesta
                $notificacion->encuesta_url = $signedUrlService->generateEncuestaLink($notificacion->id);
                return $notificacion;
            });
            
            // Pasar las notificaciones y las URLs firmadas a la vista
            $view->with('datalistNotificacionesEncuesta', $notificacionesEncuestasConUrls);
            $view->with('datalistNotificacionesPublicaciones', $notificacionesService->ListNotificacionesPublicaciones());

        });
    }
}
