<?php

namespace App\Providers;

use Illuminate\Support\Facades\View;
use App\Services\EncuestasService;
use App\Services\ZoomService;
use Illuminate\Support\ServiceProvider;
use App\Http\View\Composers\InstitucionComposer;

class AppServiceProvider extends ServiceProvider
{

    public function register(): void
    {
        $this->app->singleton(EncuestasService::class, function ($app) {
            return new EncuestasService();
        });
    }

    public static $institutions = [
        'dre' => "PUNO",
        'nombre' => "UNIVERSIDAD NACIONAL PRIVADA DE PUNO",
        'departamento' => "PUNO",
        'provincia' => "PUNO",
        'distrito' => "PUNO",
        'centro' => "PUNO",
        'sede' => "UNIVERSIDAD NACIONAL PRIVADA DE PUNO",
        'turno' => 'TARDE',
        'seccion' => 'B',
        'direccion' => "Carr. Manzanapampa S/N - Puno",
        'direccion_local' => "dirección",
        'codigo_modular' => "0723775",
        'tipo_gestion' => "PÚBLICO"
    ];

    public $institutions2 = [
        'dre' => "PUNO",
        'nombre' => "UNIVERSIDAD NACIONAL PRIVADA DE PUNO",
        'departamento' => "PUNO",
        'provincia' => "PUNO",
        'distrito' => "PUNO",
        'centro' => "PUNO",
        'sede' => "UNIVERSIDAD NACIONAL PRIVADA DE PUNO",
        'turno' => 'TARDE',
        'seccion' => 'B',
        'direccion' => "Carr. Manzanapampa S/N - Puno",
        'direccion_local' => "dirección",
        'codigo_modular' => "0723775",
        'tipo_gestion' => "PÚBLICO"
    ];

    public function boot(EncuestasService $encuestasService): void
    {
        View::composer('include.nav_header', InstitucionComposer::class);

        view()->composer(['welcome'], function ($view) {
            $view->with('institutions', $this->institutions2);
        });

        view()->composer(['admision.inscripcion'], function ($view) {
            $view->with('institutions', $this->institutions2);
        });

        view()->composer(['admin.horarios.horario_general.index'], function ($view) {
            $view->with('institutions', $this->institutions2);
        });


        view()->composer(['include.header'], function ($view) use ($encuestasService) {
            $view->with('list', $encuestasService->List_Encuestas());
        });
    }
}
