<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

class Viatico extends Model implements Auditable
{
    protected $table = 'viaticos';

    use HasFactory, \OwenIt\Auditing\Auditable;

    static $rules = [
        'usuario_id' => 'required',
        'administrator_id' => 'required',
        'fecha' => 'required',
        'nro_operacion' => 'required',
        'monto' => 'required',
        'estado' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['usuario_id', 'administrator_id', 'metodo_pago_id', 'banco_id', 'fecha', 'nro_operacion', 'descripcion', 'monto', 'documento', 'estado'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function student()
    {
        return $this->hasOne('App\Models\User', 'id', 'usuario_id');
    }


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function administrator()
    {
        return $this->hasOne('App\Models\Administrator', 'id', 'administrator_id');
    }


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function metodo_pago()
    {
        return $this->hasOne('App\Models\MetodoPago', 'id', 'metodo_pago_id');
    }


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function banco()
    {
        return $this->hasOne('App\Models\Banco', 'id', 'banco_id');
    }

}
