<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use OwenIt\Auditing\Contracts\Auditable;

class User extends Authenticatable implements Auditable
{
    protected $table = 'usuarios';

    use HasApiTokens, HasFactory, Notifiable, \OwenIt\Auditing\Auditable;

    static $rules = [
        'identificationtype_id' => 'required',
        'nroidenti' => 'required',
    ];

    protected $perPage = 20;

    protected $fillable = [
        'identificationtype_id',
        'nroidenti',
        'password',
        'google_id',
        'external_auth',
        'avatar',
        'nombres',
        'apellido_pa',
        'apellido_ma',
        'fecnac',
        'correo',
        'telefono',
        'celular',
        'direccion',
        'estado',
        'ubigeo_id',
        'genre_id',
        'usertype_id',
        'moodle_id',
    ];

    protected $hidden = [
        'password',
        // 'remember_token',
        'created_at',
        'updated_at',
    ];

    protected $casts = [
        // 'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];




    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function administradores()
    {
        return $this->hasMany('App\Models\Administrator', 'user_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function genre()
    {
        return $this->hasOne('App\Models\Genre', 'id', 'genre_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function students()
    {
        return $this->hasMany('App\Models\Student', 'user_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function teachers()
    {
        return $this->hasMany('App\Models\Teacher', 'user_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function ubigeo()
    {
        return $this->hasOne('App\Models\Ubigeo', 'id', 'ubigeo_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function usertype()
    {
        return $this->hasOne('App\Models\Usertype', 'id', 'usertype_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function identificationtype()
    {
        return $this->hasOne('App\Models\Identificationtype', 'id', 'identificationtype_id');
    }

    public function respuestas_usuarios()
    {
        return $this->hasMany(RespuestaUsuario::class);
    }
}
