<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
/**
 * Class Period
 *
 * @property $id
 * @property $numero
 * @property $descripcion
 * @property $plan_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Course[] $courses
 * @property Plan $plan
 * @property Semesterperiod[] $semesterperiods
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Unit extends Model implements Auditable
{
    protected $table = 'modulos_formativos';

    use HasFactory, \OwenIt\Auditing\Auditable;

    static $rules = [
        'plan_id' => 'required',
    ];

    protected $perPage = 20;

    protected $fillable = ['nombre','numero','descripcion', 'plan_id'];


    public function plan()
    {
        return $this->belongsTo('App\Models\Plan', 'id', 'plan_id');
    }


    public function courses()
    {
        return $this->hasMany('App\Models\Course', 'unit_id', 'id');
    }
}
