<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Ubigeo
 *
 * @property $id
 * @property $departamento
 * @property $provincia
 * @property $distrito
 * @property $created_at
 * @property $updated_at
 *
 * @property Applicant[] $applicants
 * @property Jpjob[] $jpjobs
 * @property User[] $users
 * @property Tddocument[] $tddocuments
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Ubigeo extends Model implements Auditable
{
    protected $table = 'ubigeos';

    use HasFactory, \OwenIt\Auditing\Auditable;

    static $rules = [
        'departamento' => 'required',
        'provincia' => 'required',
        'distrito' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['departamento', 'provincia', 'distrito'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function applicants()
    {
        return $this->hasMany('App\Models\Applicant', 'ubigeo_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function jpjobs()
    {
        return $this->hasMany('App\Models\Jpjob', 'ubigeo_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function tddocuments()
    {
        return $this->hasMany('App\Models\Tddocument', 'ubigeo_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function users()
    {
        return $this->hasMany('App\Models\User', 'ubigeo_id', 'id');
    }


}
