<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
/**
 * Class Period
 *
 * @property $id
 * @property $numero
 * @property $descripcion
 * @property $plan_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Course[] $courses
 * @property Plan $plan
 * @property Semesterperiod[] $semesterperiods
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Trainingmodule extends Model implements Auditable
{
    protected $table = 'modulos_formativos';

    use HasFactory, \OwenIt\Auditing\Auditable;

    static $rules = [
        'numero' => 'required',
        'descripcion' => 'required',
        'plan_id' => 'required',
    ];

    protected $perPage = 20;

    protected $fillable = ['numero','descripcion', 'plan_id'];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    public function plan()
    {
        return $this->belongsTo('App\Models\Plan', 'plan_id', 'id');
    }

    public function courses()
    {
        return $this->hasMany('App\Models\Course', 'training_module_id', 'id');
    }
}

