<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;

/**
 * Class Teachertype
 *
 * @property $id
 * @property $nombre
 * @property $descripcion
 * @property $created_at
 * @property $updated_at
 *
 * @property Teacher[] $teachers
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Teachertype extends Model implements Auditable
{
  protected $table = 'tipos_docentes';

  use HasFactory, \OwenIt\Auditing\Auditable;

  static $rules = [
    'nombre' => 'required',
    'descripcion' => 'required',
  ];

  protected $perPage = 20;

  /**
   * Attributes that should be mass-assignable.
   *
   * @var array
   */
  protected $fillable = ['nombre', 'descripcion'];


  /**
   * @return \Illuminate\Database\Eloquent\Relations\HasMany
   */
  public function teachers()
  {
    return $this->hasMany('App\Models\Teacher', 'teachertype_id', 'id');
  }
}
